/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.ai.GunAttackGoal;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.resource.gunner.GunnerLoadoutInstance;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ZombieGunnerEntity
extends MonsterEntity {
    private float damageMultiplier = 1.0f;
    private float inaccuracy = 0.15f;
    private int firerate = 20;
    private int magCapacity = 10;
    private int reloadTime = 40;
    private int burstSize;
    private int burstDelay;
    private int capColor;
    private boolean loaded;

    public ZombieGunnerEntity(World world) {
        this((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.ZOMBIE_GUNNER.get()), world);
    }

    public ZombieGunnerEntity(EntityType<? extends MonsterEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 0.23).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GunAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public void func_70636_d() {
        boolean flag;
        if (this.func_70089_S() && (flag = this.func_204609_dp())) {
            ItemStack stack = this.func_184582_a(EquipmentSlotType.HEAD);
            if (!stack.func_190926_b()) {
                if (stack.func_77984_f()) {
                    stack.func_196085_b(stack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (stack.func_77952_i() >= stack.func_77958_k()) {
                        this.func_213361_c(EquipmentSlotType.HEAD);
                        this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    public ILivingEntityData func_213386_a(IServerWorld serverWorld, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData data, CompoundNBT nbt) {
        data = super.func_213386_a(serverWorld, difficulty, reason, data, nbt);
        this.func_180481_a(difficulty);
        return data;
    }

    protected void func_213345_d(DamageSource p_213345_1_) {
        super.func_213345_d(p_213345_1_);
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
    }

    protected void func_180483_b(DifficultyInstance p_180483_1_) {
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        GunnerLoadoutInstance loadout = GunsRPG.getModLifecycle().getZombieGunnerWeaponManager().getLoadout();
        if (loadout == null) {
            GunsRPG.log.fatal("Cannot generate loadout for " + (Object)((Object)this) + ", loadout configuration not found!");
            return;
        }
        loadout.applyGear(this, difficulty.func_203095_a());
        boolean coloredCap = this.capColor >= 0;
        ItemStack head = new ItemStack((IItemProvider)Items.field_151024_Q);
        if (coloredCap) {
            CompoundNBT data = new CompoundNBT();
            CompoundNBT display = new CompoundNBT();
            display.func_74768_a("color", this.capColor);
            data.func_218657_a("display", (INBT)display);
            head.func_77982_d(data);
        }
        this.func_184201_a(EquipmentSlotType.HEAD, head);
        this.loaded = true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("damageMultiplier", this.damageMultiplier);
        compound.func_74776_a("inaccuracy", this.inaccuracy);
        compound.func_74768_a("magCapacity", this.magCapacity);
        compound.func_74768_a("firerate", this.firerate);
        compound.func_74768_a("reloadTime", this.reloadTime);
        compound.func_74768_a("burstSize", this.burstSize);
        compound.func_74768_a("burstDelay", this.burstDelay);
        compound.func_74757_a("initializedLoadout", this.loaded);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.damageMultiplier = compound.func_74760_g("damageMultiplier");
        this.inaccuracy = compound.func_74760_g("inaccuracy");
        this.magCapacity = compound.func_74762_e("magCapacity");
        this.firerate = compound.func_74762_e("firerate");
        this.reloadTime = compound.func_74762_e("reloadTime");
        this.burstSize = compound.func_74762_e("burstSize");
        this.burstDelay = compound.func_74762_e("burstDelay");
        this.loaded = compound.func_74767_n("initializedLoadout");
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public void setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
    }

    public void setFirerate(int firerate) {
        this.firerate = firerate;
    }

    public void setMagCapacity(int magCapacity) {
        this.magCapacity = magCapacity;
    }

    public void setReloadTime(int reloadTime) {
        this.reloadTime = reloadTime;
    }

    public void setBurstSize(int burstSize) {
        this.burstSize = burstSize;
    }

    public void setBurstDelay(int burstDelay) {
        this.burstDelay = burstDelay;
    }

    public void setCapColor(int capColor) {
        this.capColor = capColor;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    public int getFirerate() {
        return this.firerate;
    }

    public int getMagCapacity() {
        return this.magCapacity;
    }

    public int getReloadTime() {
        return this.reloadTime;
    }

    public int getBurstSize() {
        return this.burstSize;
    }

    public int getBurstDelay() {
        return this.burstDelay;
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

